<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfficeEventSpace extends Model
{
    use HasFactory;

    const TYPE_OFFICE = 'Office';
    const TYPE_EVENT = 'Event';

    protected $fillable = [
        'uuid',
        'type',
        'room',
        'floor',
        'size',
        'additional_space',
        'amenities',
        'sort',
        'status'
    ];

    public function statusBadge($status){
        $html = '';
        if($this->status == 1) {
            $html = '<span class="badge badge--success">'.trans('Active').'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans('Inactive').'</span>';
        }

        return $html;
    }
}
