<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\PageViewLog;

class LogPageView
{
    /**
     * Handle an incoming request and log a page view.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Allow the request to run first so we can inspect the response status.
        $response = $next($request);

        try {
            // Only log GET requests from frontend (skip admin routes and non-HTML responses)
            if ($request->isMethod('get')) {
                // Skip admin area
                if ($request->is('admin') || $request->is('admin/*')) {
                    return $response;
                }

                // Only log successful HTML responses
                if (method_exists($response, 'getStatusCode') && $response->getStatusCode() !== 200) {
                    return $response;
                }

                $contentType = $response->headers->get('Content-Type') ?? '';
                if (stripos($contentType, 'text/html') === false && stripos($contentType, 'application/xhtml+xml') === false) {
                    return $response;
                }

                $path = $request->path();
                $title = null;
                $ip = $request->ip();
                $ua = $request->userAgent() ?: '';

                PageViewLog::create([
                    'path' => $path,
                    'title' => $title,
                    'ip' => $ip,
                    'user_agent' => $ua,
                    'views' => 1,
                    'view_date' => now()->toDateString(),
                ]);
            }
        } catch (\Throwable $e) {
            // Swallow any logging errors so they don't affect user requests.
        }

        return $response;
    }
}
