<?php

namespace App\Http\Controllers\Admin;


use App\Models\Portfolio;
use Illuminate\Http\Request;
use App\Rules\FileTypeValidate;
use App\Http\Controllers\Controller;
use App\Models\ReportAndInside;
use App\Models\ReportAndInsideCategory;

class ReportInsideController extends Controller
{
    public function index(){
        $pageTitle = 'Report & Inside';
        $reports = ReportAndInside::orderBy('created_at','desc')->paginate(getPaginate());
        return view('admin.report_and_inside.index',compact('pageTitle','reports'));
    }

    public function create(){
        $pageTitle = 'Add Report & Inside';
        $categories = ReportAndInsideCategory::orderBy('name')->get();
        return view('admin.report_and_inside.create',compact('pageTitle', 'categories'));
    }

    public function edit($id){
        $pageTitle = 'Update';
        $report = ReportAndInside::findOrFail($id);
        $categories = ReportAndInsideCategory::orderBy('name')->get();
        return view('admin.report_and_inside.edit',compact('pageTitle', 'categories', 'report'));

    }

    public function store(Request $request){

        $request->validate([
            'title'=>'required',
            'category' => 'required',
            'image' => ['required', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
            'status' => 'required',
        ]);

        $purifier = new \HTMLPurifier();

        $report = new ReportAndInside();
        $report->slug = slug($request->title);
        $report->title = $request->title;
        $report->category_id = $request->category;
        $report->download_report_external_url = $request->download_report_external_url;
        $report->description = $purifier->purify($request->description);
        $report->status = $request->status == 1 ? 1:0;

        if ($request->hasFile('image')) {
            try {
                $report->image = fileUploader($request->image,getFilePath('reportInsideImage'));
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }

        if ($request->hasFile('download_report_file')) {
            try {
                $report->download_report_file = fileUploader($request->download_report_file,getFilePath('reportInsideImage'));
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your report file'];
                return back()->withNotify($notify);
            }
        }
        $report->save();

        $notify[] = ['success', 'Report & Inside has been created successfully'];
        return back()->withNotify($notify);

    }

    public function update(Request $request,$id){
        $request->validate([
            'title'=>'required',
            'category' => 'required',
            'image' => ['nullable', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ]);

        $purifier = new \HTMLPurifier();

        $report = ReportAndInside::findOrFail($id);
        $report->title = $request->title;
        $report->category_id = $request->category;
        if (!$report->slug) {
            $report->slug = slug($request->title);
        }
        // $report->description = $purifier->purify($request->description);
        $report->description = $request->description;
        $report->download_report_external_url = $request->download_report_external_url;
        $report->status = $request->status == 1 ? 1:0;

        if ($request->hasFile('image')) {
            try {
                $old = $report->image;
                $report->image = fileUploader($request->image,getFilePath('reportInsideImage'), null,$old);

            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }

        if ($request->hasFile('download_report_file')) {
            try {
                $old_file = $report->download_report_file;
                $report->download_report_file = fileUploader($request->download_report_file,getFilePath('reportInsideImage'), null,$old_file);

            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your report file'];
                return back()->withNotify($notify);
            }
        }

        $report->save();

        $notify[] = ['success', 'Report & Inside has been updated successfully'];
        return back()->withNotify($notify);

    }

    public function delete(Request $request){
        $report = ReportAndInside::findOrFail($request->id);

        $path = getFilePath('reportInsideImage') . '/' . $report->image;
        fileManager()->removeFile($path);
        $report->delete();

        $notify[] = ['success', 'Report & Inside has been deleted'];
        return back()->withNotify($notify);
    }
}
