<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ReportDownload;
use Illuminate\Http\Request;

class ReportDownloadController extends Controller
{
    /**
     * Display a listing of report downloads for admin.
     */
    public function index(Request $request)
    {
        $pageTitle = 'Report Downloads';

        // Get total count for display
        $totalDownloads = ReportDownload::count();

        $downloads = ReportDownload::with('report')->orderBy('id', 'desc');

        if ($request->search) {
            $search = $request->search;
            $downloads = $downloads->where(function ($q) use ($search) {
                $q->where('first_name', 'like', "%$search%")
                  ->orWhere('last_name', 'like', "%$search%")
                  ->orWhere('email', 'like', "%$search%");
            });
        }

        $downloads = $downloads->paginate(function_exists('getPaginate') ? getPaginate() : 15);

        return view('admin.reportdownloads.index', compact('pageTitle', 'downloads', 'totalDownloads'));
    }
}
