<?php

namespace App\Http\Controllers\Admin;


use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Rules\FileTypeValidate;
use App\Models\OfficeEventSpace;
use App\Http\Controllers\Controller;
use App\Models\OfficeEventSpaceSlide;

class OfficeEventSpaceSlideController extends Controller
{
    public function index(){
        $pageTitle = 'Office and Event Space Slides';
        $slides = OfficeEventSpaceSlide::orderBy('created_at','desc')->get();
        return view('admin.office_and_event_space.slides.index',compact('pageTitle','slides'));
    }

    public function create(){
        $pageTitle = 'Add Slide';
        return view('admin.office_and_event_space.slides.create',compact('pageTitle'));
    }

    public function edit($id){
        $pageTitle = 'Update Slide';
        $slide = OfficeEventSpaceSlide::findOrFail($id);
        return view('admin.office_and_event_space.slides.edit',compact('pageTitle', 'slide'));

    }

    public function store(Request $request){

        $request->validate([
            'image' => ['required', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
            'status' => 'required',
        ]);

        $slide = new OfficeEventSpaceSlide();
        $slide->status = $request->status == 1 ? 1:0;

        if ($request->hasFile('image')) {
            try {
                $slide->image = fileUploader($request->image,getFilePath('uploads'));
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }

        $slide->save();

        $notify[] = ['success', 'Slide has been created successfully'];
        return back()->withNotify($notify);
    }

    public function update(Request $request,$id){
        $request->validate([
            'image' => ['nullable', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
            'status' => 'required',
        ]);

        $slide = OfficeEventSpaceSlide::findOrFail($id);
        $slide->status = $request->status == 1 ? 1:0;
        if ($request->hasFile('image')) {
            try {
                $old = $slide->image;
                $slide->image = fileUploader($request->image,getFilePath('uploads'), null,$old);
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }
        $slide->save();

        $notify[] = ['success', 'Slide has been updated successfully'];
        return back()->withNotify($notify);

    }

    public function delete(Request $request){
        $slide = OfficeEventSpaceSlide::findOrFail($request->id);

        $path = getFilePath('uploads') . '/' . $slide->image;
        fileManager()->removeFile($path);
        $slide->delete();

        $notify[] = ['success', 'Slide has been deleted'];
        return back()->withNotify($notify);
    }
}
