<?php

namespace App\Http\Controllers\Admin;


use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Rules\FileTypeValidate;
use App\Models\OfficeEventSpace;
use App\Http\Controllers\Controller;

class OfficeEventSpaceController extends Controller
{
    public function index(){
        $pageTitle = 'Office and Event Space';
        $officeSpaces = OfficeEventSpace::where('type', OfficeEventSpace::TYPE_OFFICE)
            ->orderBy('created_at','desc')->get();
        $eventSpaces = OfficeEventSpace::where('type', OfficeEventSpace::TYPE_EVENT)
            ->orderBy('created_at','desc')->get();
        return view('admin.office_and_event_space.index',compact('pageTitle','officeSpaces', 'eventSpaces'));
    }

    public function create(){
        $pageTitle = 'Add Office and Event Space';
        return view('admin.office_and_event_space.create',compact('pageTitle'));
    }

    public function edit($id){
        $pageTitle = 'Update';
        $row = OfficeEventSpace::findOrFail($id);
        return view('admin.office_and_event_space.edit',compact('pageTitle', 'row'));

    }

    public function store(Request $request){

        $request->validate([
            'type'=>'required',
            'room' => 'required',
            'status' => 'required',
        ]);

        $officeEventSpace = new OfficeEventSpace();
        $officeEventSpace->uuid = Str::uuid()->toString();
        $officeEventSpace->type = $request->type;
        $officeEventSpace->room = $request->room;
        $officeEventSpace->floor = $request->floor;
        $officeEventSpace->size = $request->size;
        $officeEventSpace->additional_space = $request->additional_space;
        $officeEventSpace->amenities = $request->amenities;
        $officeEventSpace->status = $request->status == 1 ? 1:0;
        $officeEventSpace->save();

        $notify[] = ['success', 'Office and Event Space has been created successfully'];
        return back()->withNotify($notify);
    }

    public function update(Request $request,$id){
        $request->validate([
            'type'=>'required',
            'room' => 'required',
            'status' => 'required',
        ]);

        $officeEventSpace = OfficeEventSpace::findOrFail($id);
        $officeEventSpace->type = $request->type;
        $officeEventSpace->room = $request->room;
        $officeEventSpace->floor = $request->floor;
        $officeEventSpace->size = $request->size;
        $officeEventSpace->additional_space = $request->additional_space;
        $officeEventSpace->amenities = $request->amenities;
        $officeEventSpace->status = $request->status == 1 ? 1:0;
        $officeEventSpace->save();

        $notify[] = ['success', 'Office and Event Space has been updated successfully'];
        return back()->withNotify($notify);

    }

    public function delete(Request $request){
        $report = OfficeEventSpace::findOrFail($request->id);
        $report->delete();

        $notify[] = ['success', 'Office and Event Space has been deleted'];
        return back()->withNotify($notify);
    }
}
