<?php

namespace App\Http\Controllers\Admin;


use App\Models\Career;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Rules\FileTypeValidate;
use App\Http\Controllers\Controller;

class CareerController extends Controller
{
    public function index(){
        $pageTitle = 'Career Center';
        $rows = Career::orderBy('created_at','desc')->paginate(getPaginate());
        return view('admin.careers.index',compact('pageTitle','rows'));
    }

    public function create(){
        $pageTitle = 'Add Career';
        return view('admin.careers.create',compact('pageTitle'));
    }

    public function edit($id){
        $pageTitle = 'Update';
        $row = Career::findOrFail($id);
        return view('admin.careers.edit',compact('pageTitle', 'row'));

    }

    public function store(Request $request){

        $request->validate([
            'title'=>'required',
            'status' => 'required',
        ]);

        $purifier = new \HTMLPurifier();

        // format date to db from dd/mm/yyyy to yyyy-mm-dd
        $date = \Carbon\Carbon::createFromFormat('d/m/Y', $request->date);

        $career = new Career();
        $career->uuid = Str::uuid()->toString();
        $career->date = $date->format('Y-m-d');
        $career->title = $request->title;
        $career->salary_range_min = $request->salary_range_min;
        $career->salary_range_max = $request->salary_range_max;
        $career->experience_min = $request->experience_min;
        $career->experience_max = $request->experience_max;
        $career->company_type = $request->company_type;
        $career->location = $request->location;
        $career->apply_url = $request->apply_url;
        $career->requirement = $purifier->purify($request->requirement);
        $career->status = $request->status == 1 ? 1:0;

        $career->save();

        $notify[] = ['success', 'Career has been created successfully'];
        return back()->withNotify($notify);

    }

    public function update(Request $request,$id){
        $request->validate([
            'title'=>'required',
        ]);

        $purifier = new \HTMLPurifier();

        // format date to db from dd/mm/yyyy to yyyy-mm-dd
        $date = \Carbon\Carbon::createFromFormat('d/m/Y', $request->date);

        $career = Career::findOrFail($id);
        $career->date = $date->format('Y-m-d');
        $career->title = $request->title;
        $career->salary_range_min = $request->salary_range_min;
        $career->salary_range_max = $request->salary_range_max;
        $career->experience_min = $request->experience_min;
        $career->experience_max = $request->experience_max;
        $career->company_type = $request->company_type;
        $career->location = $request->location;
        $career->apply_url = $request->apply_url;
        $career->requirement = $purifier->purify($request->requirement);
        $career->status = $request->status == 1 ? 1:0;
        $career->save();

        $notify[] = ['success', 'Career has been updated successfully'];
        return back()->withNotify($notify);

    }

    public function delete(Request $request){
        $report = Career::findOrFail($request->id);

        $path = getFilePath('reportInsideImage') . '/' . $report->image;
        fileManager()->removeFile($path);
        $report->delete();

        $notify[] = ['success', 'Career has been deleted'];
        return back()->withNotify($notify);
    }
}
