<?php

namespace App\Http\Controllers\Admin;

use App\Models\News;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Rules\FileTypeValidate;
use App\Http\Controllers\Controller;

class BlogController extends Controller
{
    public function index(){
        $pageTitle = 'Report & Inside';
        $rows = News::orderBy('created_at','desc')->paginate(getPaginate());
        return view('admin.blog.index',compact('pageTitle','rows'));
    }

    public function create(){
        $pageTitle = 'Add News';
        return view('admin.blog.create',compact('pageTitle'));
    }

    public function edit($id){
        $pageTitle = 'Update';
        $row = News::findOrFail($id);
        return view('admin.blog.edit',compact('pageTitle', 'row'));

    }

    public function store(Request $request){

        $request->validate([
            'title'=>'required',
            'featured_image' => ['required', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
            'status' => 'required',
        ]);

        // $purifier = new \HTMLPurifier();

        $blog = new News();
        $blog->uuid = Str::uuid()->toString();
        $blog->slug = slug($request->title);
        $blog->title = $request->title;
        $blog->description = $request->description;
        $blog->status = $request->status == 1 ? 1:0;

        if ($request->hasFile('featured_image')) {
            try {
                $blog->featured_image = fileUploader($request->featured_image,getFilePath('blog'));
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }
        $blog->save();

        $notify[] = ['success', 'News has been created successfully'];
        return back()->withNotify($notify);

    }

    public function update(Request $request,$id){
        $request->validate([
            'title'=>'required',
            'featured_image' => ['nullable', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ]);

        $purifier = new \HTMLPurifier();

        $blog = News::findOrFail($id);
        $blog->title = $request->title;
        if (!$blog->slug) {
            $blog->slug = slug($request->title);
        }
        $blog->description = $request->description;
        $blog->status = $request->status == 1 ? 1:0;

        if ($request->hasFile('featured_image')) {
            try {
                $old = $blog->featured_image;
                $blog->featured_image = fileUploader($request->featured_image,getFilePath('blog'), null,$old);

            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }
        $blog->save();

        $notify[] = ['success', 'News has been updated successfully'];
        return back()->withNotify($notify);

    }

    public function delete(Request $request){
        $blog = News::findOrFail($request->id);

        $path = getFilePath('blog') . '/' . $blog->featured_image;
        fileManager()->removeFile($path);
        $blog->delete();

        $notify[] = ['success', 'News has been deleted'];
        return back()->withNotify($notify);
    }
}
