Google Analytics integration (server-side)

This project includes a lightweight helper to fetch `totalUsers` from Google Analytics 4 (Data API) and show it in the homepage counters as `Total Viewers`.

Setup steps:

1. Create a Google Cloud Service Account with the role `Viewer` and grant it access to your Google Analytics property (GA4). Follow Google docs: https://developers.google.com/analytics/devguides/reporting/data/v1/quickstart-service-php

2. Download the service account JSON key file and place it somewhere on the server, e.g. `storage/ga/service-account.json`.

3. Add these environment variables to your `.env` (or hosting env):

Option A — Local / file-based (recommended for local dev servers)

```
GA_ENABLED=true
GA_PROPERTY_ID=123456789   # your GA4 property numeric id
GA_SERVICE_ACCOUNT_JSON=/absolute/path/to/service-account.json
```

Option B — Production / env-based (when you cannot store files on disk)

You can store the JSON key directly in an environment variable. The service supports either raw JSON or base64-encoded JSON as the value of `GA_SERVICE_ACCOUNT_JSON`. Example (base64):

```bash
# on your production machine, base64 the JSON and add to env
export GA_ENABLED=true
export GA_PROPERTY_ID=123456789
export GA_SERVICE_ACCOUNT_JSON="$(base64 -w0 /path/to/service-account.json)"
```

Or set the raw JSON string directly (be careful with quoting). The service will detect and decode base64 automatically.

Note: `GA_PROPERTY_ID` should be the numeric property id (not the measurement id). Example: `123456789`.

4. Clear config cache and reload:

```bash
php artisan config:clear
php artisan cache:clear
php artisan view:clear
```

5. The site will attempt to call the Analytics Data API when rendering the homepage and populate the `viewers` counter. If the credentials are missing or the request fails, the frontend will fall back to the static CMS counter value.

Security note: Keep the JSON key file private and give it restricted filesystem permissions.

Troubleshooting:

-   If the totals show blank, check your webserver logs. The helper returns null on error and falls back silently.
-   If you encounter JWT or openssl issues, ensure `ext-openssl` is enabled in PHP and Guzzle is installed (this project includes Guzzle via Composer by default).

Tips & verification

-   To check quickly from the project root (after env + file set), run:

```bash
php application/artisan tinker --execute "echo app(\App\Services\GoogleAnalyticsService::class)->getTotalUsers(\Carbon\Carbon::now()->subDays(30), \Carbon\Carbon::now());"
```

-   If you use the env-based JSON (base64), ensure the env is available to PHP-FPM / your process manager so the app can read it.

If you want, I can add a short deploy snippet (CI/CD) to write the env JSON into a secure file at build time and set the correct `GA_SERVICE_ACCOUNT_JSON` path for you.

If you want, I can also add a cached daily snapshot of the GA value to avoid live API calls on every page view.
